/*
 * Decompiled with CFR 0.152.
 */
package jace.cheat;

import jace.apple2e.RAM128k;
import jace.cheat.Cheats;
import jace.cheat.MemorySpy;
import jace.cheat.MetaCheatForm;
import jace.core.Computer;
import jace.core.KeyHandler;
import jace.core.Keyboard;
import jace.core.RAMEvent;
import jace.core.RAMListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.DefaultTableModel;

public class MetaCheats
extends Cheats {
    static MetaCheats singleton = null;
    boolean noCheats = true;
    Map<Integer, Integer> holdBytes = new TreeMap<Integer, Integer>();
    Map<Integer, Integer> holdWords = new TreeMap<Integer, Integer>();
    Set<Integer> disabled = new HashSet<Integer>();
    Map<Integer, Integer> results = new TreeMap<Integer, Integer>();
    public static int MAX_RESULTS_SHOWN = 256;
    public MetaCheatForm form = null;
    public boolean isDrawing = false;
    MemorySpy spy = null;

    public MetaCheats() {
        singleton = this;
    }

    @Override
    protected String getDeviceName() {
        return "Meta-cheat engine";
    }

    @Override
    public void tick() {
    }

    public void redrawResults() {
        if (this.isDrawing) {
            return;
        }
        this.isDrawing = true;
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(MetaCheats.class.getName()).log(Level.SEVERE, null, ex);
        }
        RAM128k ram = (RAM128k)Computer.getComputer().getMemory();
        DefaultTableModel model = (DefaultTableModel)this.form.resultsTable.getModel();
        if (this.results.size() > MAX_RESULTS_SHOWN) {
            model.setRowCount(0);
            this.isDrawing = false;
            return;
        }
        boolean useWord = this.form.searchForWord.isSelected();
        if (model.getRowCount() != this.results.size()) {
            model.setRowCount(0);
            ArrayList<Integer> iter = new ArrayList<Integer>(this.results.keySet());
            for (Integer i : iter) {
                int current;
                int val = this.results.get(i);
                if (useWord) {
                    current = ram.readWordRaw(i) & 0xFFFF;
                    model.addRow(new Object[]{MetaCheats.hex(i, 4), val + " (" + MetaCheats.hex(val, 4) + ")", current + " (" + MetaCheats.hex(current, 4) + ")"});
                    continue;
                }
                current = ram.readRaw(i) & 0xFF;
                model.addRow(new Object[]{MetaCheats.hex(i, 4), val + " (" + MetaCheats.hex(val, 2) + ")", current + " (" + MetaCheats.hex(current, 2) + ")"});
            }
        } else {
            ArrayList<Integer> iter = new ArrayList<Integer>(this.results.keySet());
            for (int i = 0; i < iter.size(); ++i) {
                int current;
                int val = this.results.get(iter.get(i));
                if (useWord) {
                    current = ram.readWordRaw((Integer)iter.get(i)) & 0xFFFF;
                    model.setValueAt(val + " (" + MetaCheats.hex(val, 4) + ")", i, 1);
                    model.setValueAt(current + " (" + MetaCheats.hex(current, 4) + ")", i, 2);
                    continue;
                }
                current = ram.readRaw((Integer)iter.get(i)) & 0xFF;
                model.setValueAt(val + " (" + MetaCheats.hex(val, 2) + ")", i, 1);
                model.setValueAt(current + " (" + MetaCheats.hex(current, 2) + ")", i, 2);
            }
        }
        this.isDrawing = false;
    }

    public static String hex(int val, int size) {
        String out = Integer.toHexString(val);
        while (out.length() < size) {
            out = "0" + out;
        }
        return "$" + out;
    }

    public void redrawCheats() {
        int val;
        String loc;
        this.noCheats = this.holdBytes.isEmpty() && this.holdWords.isEmpty() && this.disabled.isEmpty();
        DefaultTableModel model = (DefaultTableModel)this.form.activeCheatsTable.getModel();
        model.setRowCount(0);
        for (Integer i : this.holdBytes.keySet()) {
            loc = MetaCheats.hex(i, 4);
            if (this.disabled.contains(i)) {
                loc = loc + " (off)";
            }
            val = this.holdBytes.get(i);
            model.addRow(new Object[]{loc, val + " (" + MetaCheats.hex(val, 2) + ")"});
        }
        for (Integer i : this.holdWords.keySet()) {
            loc = MetaCheats.hex(i, 4);
            if (this.disabled.contains(i)) {
                loc = loc + " (off)";
            }
            val = this.holdWords.get(i);
            model.addRow(new Object[]{loc, val + " (" + MetaCheats.hex(val, 4) + ")"});
        }
    }

    public void showCheatForm() {
        if (this.form == null) {
            this.form = new MetaCheatForm();
        }
        this.form.setVisible(true);
    }

    public void showMemorySpy() {
        if (this.spy == null) {
            this.spy = new MemorySpy();
        }
        this.spy.setVisible(true);
    }

    @Override
    public void attach() {
        this.addCheat(new RAMListener(RAMEvent.TYPE.READ, RAMEvent.SCOPE.ANY, RAMEvent.VALUE.ANY){

            @Override
            protected void doConfig() {
            }

            @Override
            protected void doEvent(RAMEvent e) {
                if (MetaCheats.this.noCheats) {
                    return;
                }
                if (MetaCheats.this.disabled.contains(e.getAddress())) {
                    return;
                }
                if (MetaCheats.this.holdBytes.containsKey(e.getAddress())) {
                    e.setNewValue(MetaCheats.this.holdBytes.get(e.getAddress()));
                } else if (MetaCheats.this.holdWords.containsKey(e.getAddress())) {
                    e.setNewValue((int)(MetaCheats.this.holdWords.get(e.getAddress()) & 0xFF));
                } else if (MetaCheats.this.holdWords.containsKey(e.getAddress() - 1)) {
                    if (MetaCheats.this.disabled.contains(e.getAddress() - 1)) {
                        return;
                    }
                    e.setNewValue(MetaCheats.this.holdWords.get(e.getAddress() - 1) >> 8 & 0xFF);
                }
            }
        });
        this.addCheat(new RAMListener(RAMEvent.TYPE.WRITE, RAMEvent.SCOPE.ANY, RAMEvent.VALUE.ANY){

            @Override
            protected void doConfig() {
            }

            @Override
            protected void doEvent(RAMEvent e) {
                if (MetaCheats.this.results.isEmpty()) {
                    return;
                }
                if (MetaCheats.this.results.size() > MAX_RESULTS_SHOWN || MetaCheats.this.isDrawing) {
                    return;
                }
                if (MetaCheats.this.results.containsKey(e.getAddress()) || MetaCheats.this.results.containsKey(e.getAddress() - 1)) {
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            MetaCheats.this.redrawResults();
                        }
                    });
                    t.setName("Metacheat results updater");
                    t.start();
                }
            }
        });
        Keyboard.registerKeyHandler(new KeyHandler(35, new int[0]){

            @Override
            public boolean handleKeyUp(KeyEvent e) {
                MetaCheats.this.showCheatForm();
                return false;
            }

            @Override
            public boolean handleKeyDown(KeyEvent e) {
                return false;
            }
        }, this);
        Keyboard.registerKeyHandler(new KeyHandler(36, new int[0]){

            @Override
            public boolean handleKeyUp(KeyEvent e) {
                MetaCheats.this.showMemorySpy();
                return false;
            }

            @Override
            public boolean handleKeyDown(KeyEvent e) {
                return false;
            }
        }, this);
    }

    @Override
    public void detach() {
        super.detach();
        Keyboard.unregisterAllHandlers(this);
    }

    public void addByteCheat(int addr, int val) {
        this.holdBytes.put(addr, val);
        this.redrawCheats();
    }

    public void addWordCheat(int addr, int val) {
        this.holdWords.put(addr, val);
        this.redrawCheats();
    }

    void removeCheat(int i) {
        this.holdBytes.remove(i);
        this.holdWords.remove(i);
        this.disabled.remove(i);
        this.redrawCheats();
    }

    void resetSearch() {
        this.results.clear();
        this.redrawResults();
    }

    void performSearch(boolean useDeltaSearch, boolean searchForByteValues, int val) {
        RAM128k ram = (RAM128k)Computer.getComputer().getMemory();
        if (this.results.isEmpty()) {
            int max = 65536;
            if (!searchForByteValues) {
                --max;
            }
            for (int i = 0; i < max; ++i) {
                int v;
                if (i >= 49152 && i <= 53247) continue;
                int n = v = searchForByteValues ? ram.readRaw(i) & 0xFF : ram.readWordRaw(i) & 0xFFFF;
                if (useDeltaSearch) {
                    this.results.put(i, v);
                    continue;
                }
                if (v != val) continue;
                this.results.put(i, v);
            }
        } else {
            HashSet<Integer> remove = new HashSet<Integer>();
            for (Integer i : this.results.keySet()) {
                int v;
                int n = v = searchForByteValues ? ram.readRaw(i) & 0xFF : ram.readWordRaw(i) & 0xFFFF;
                if (useDeltaSearch) {
                    if (v - this.results.get(i) != val) {
                        remove.add(i);
                        continue;
                    }
                    this.results.put(i, v);
                    continue;
                }
                if (v != val) {
                    remove.add(i);
                    continue;
                }
                this.results.put(i, v);
            }
            for (Integer i : remove) {
                this.results.remove(i);
            }
        }
        this.form.resultsStatusLabel.setText("Search found " + this.results.size() + " result(s).");
        this.redrawResults();
    }

    void enableCheat(int addr) {
        this.disabled.remove(addr);
        this.redrawCheats();
    }

    void disableCheat(int addr) {
        this.disabled.add(addr);
        this.redrawCheats();
    }

    void addWatches(int addrStart, int addrEnd) {
        RAM128k ram = (RAM128k)Computer.getComputer().getMemory();
        if (this.form == null) {
            return;
        }
        boolean searchForByteValues = this.form.searchForByte.isSelected();
        for (int i = addrStart; i <= addrEnd; i += searchForByteValues ? 1 : 2) {
            int v = searchForByteValues ? ram.readRaw(i) & 0xFF : ram.readWordRaw(i) & 0xFFFF;
            this.results.put(i, v);
        }
        this.redrawResults();
    }
}

